/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAdminPrivileges;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class Stage
implements VerificationConstants,
MultiTaskHandler {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    protected boolean m_excludeUserEquiv;
    protected String[] m_nodeList;
    protected String[] m_validNodeList;
    protected int m_verificationMode;
    private Vector m_currentTaskSet = new Vector();
    protected ParamManager m_paramMgr;
    protected ResultSet m_resultSet = new ResultSet();
    protected boolean bNodeAddOper = false;

    Stage(int verificationMode) throws StageInitException {
        Trace.out((String)"Inside constructor of Stage(mode)...");
        this.m_verificationMode = verificationMode;
    }

    public void init() throws StageInitException {
        ArrayList newNodeList = new ArrayList();
        Trace.out((String)"Inside init of Stage...");
        try {
            this.m_paramMgr = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((String)("UNINITIALZEDPARMMGREXCEPTION: \n" + e.getMessage()));
            throw new StageInitException(e.getMessage());
        }
        this.bNodeAddOper = this.m_paramMgr.isNodeAdd();
        String autoNodeListStr = VerificationUtil.getVariableValue("AUTO_LIST");
        String hubNodeListStr = VerificationUtil.getVariableValue("HUB_LIST");
        String rimNodeListStr = VerificationUtil.getVariableValue("RIM_LIST");
        String targetHubSizeStr = VerificationUtil.getVariableValue("TARGET_HUB_SIZE");
        if (autoNodeListStr != null || hubNodeListStr != null || rimNodeListStr != null) {
            ArrayList<String> allNodeList = new ArrayList<String>();
            if (autoNodeListStr != null) {
                allNodeList.addAll(Arrays.asList(autoNodeListStr.split(",")));
            }
            if (hubNodeListStr != null) {
                allNodeList.addAll(Arrays.asList(hubNodeListStr.split(",")));
            }
            if (rimNodeListStr != null) {
                allNodeList.addAll(Arrays.asList(rimNodeListStr.split(",")));
            }
            VerificationUtil.setLocalNodeFirst(allNodeList);
            this.m_nodeList = allNodeList.toArray(new String[0]);
        } else {
            try {
                this.m_nodeList = VerificationUtil.getNodelist();
            }
            catch (NodelistNotFoundException e) {
                throw new StageInitException(e.getMessage());
            }
        }
        this.initNodeManager();
    }

    protected void initNodeManager() throws StageInitException {
        block23: {
            NodeManager nm = null;
            if (this.m_nodeList == null) {
                Trace.out((String)"m_nodeList is not initialized");
                throw new StageInitException(s_msgBundle.getMessage("7508", true));
            }
            try {
                NodeManagerFactory nmf;
                String autoNodeListStr = VerificationUtil.getVariableValue("AUTO_LIST");
                String hubNodeListStr = VerificationUtil.getVariableValue("HUB_LIST");
                String rimNodeListStr = VerificationUtil.getVariableValue("RIM_LIST");
                String targetHubSizeStr = VerificationUtil.getVariableValue("TARGET_HUB_SIZE");
                if (autoNodeListStr != null || hubNodeListStr != null || rimNodeListStr != null) {
                    Trace.out((String)"Creating NodeMamanger with autoNodes=%s, hubNodes=%s, rimNodes=%s, targetHubSize=%s", (Object[])new Object[]{autoNodeListStr, hubNodeListStr, rimNodeListStr, targetHubSizeStr});
                    int targetHubSize = 0;
                    String[] autoNodeList = null;
                    String[] hubNodeList = null;
                    String[] rimNodeList = null;
                    if (autoNodeListStr != null) {
                        autoNodeList = autoNodeListStr.split(",");
                    }
                    if (hubNodeListStr != null) {
                        hubNodeList = hubNodeListStr.split(",");
                    }
                    if (rimNodeListStr != null) {
                        rimNodeList = rimNodeListStr.split(",");
                    }
                    if (targetHubSizeStr != null) {
                        targetHubSize = Integer.parseInt(targetHubSizeStr);
                    } else {
                        if (autoNodeList != null) {
                            targetHubSize = autoNodeList.length;
                        }
                        if (hubNodeList != null) {
                            targetHubSize += hubNodeList.length;
                        }
                    }
                    NodeManagerFactory nmf2 = NodeManagerFactory.getInstance();
                    if (this.bNodeAddOper) {
                        nm = nmf2.getNodeManager();
                        try {
                            nm.addNodes(hubNodeList, rimNodeList, autoNodeList, targetHubSize);
                            break block23;
                        }
                        catch (NodeManagerException nme) {
                            Trace.out((String)("NodeManagerException :" + nme.getMessage()));
                            Trace.stackTrace();
                            throw new StageInitException(nme.getMessage());
                        }
                    }
                    nm = nmf2.getNodeManager(hubNodeList, rimNodeList, autoNodeList, targetHubSize);
                    break block23;
                }
                String crsHome = null;
                String haHome = null;
                boolean crsRunning = false;
                boolean haRunning = false;
                ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                try {
                    if (VerificationUtil.isCRSConfigured()) {
                        crsHome = VerificationUtil.getCRSHome();
                        Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj(true);
                        if (crsActiveVersion != null && VerificationUtil.isStringGood(crsHome)) {
                            crsRunning = clusterwareInfo.isCRSRunning(crsHome, crsActiveVersion);
                        }
                    } else if (VerificationUtil.isHAConfigured()) {
                        haHome = VerificationUtil.getHAHome();
                        haRunning = clusterwareInfo.isHARunning(haHome);
                    }
                }
                catch (InstallException e) {
                    Trace.out((String)("InstallException :" + e.getMessage()));
                    crsRunning = false;
                    haRunning = false;
                }
                if (crsRunning || haRunning) {
                    Trace.out((String)"CRS is configured. Creating node manager without any arguments");
                    nmf = NodeManagerFactory.getInstance();
                    nm = nmf.getNodeManager();
                    if (!this.bNodeAddOper) break block23;
                    try {
                        nm.addNodes(this.m_nodeList);
                        break block23;
                    }
                    catch (NodeManagerException nme) {
                        Trace.out((String)("NodeManagerException :" + nme.getMessage()));
                        Trace.stackTrace();
                        throw new StageInitException(nme.getMessage());
                    }
                }
                Trace.out((String)("both CRS/HA not running. Creating nodeManager with node list: " + VerificationUtil.strArr2List(this.m_nodeList)));
                nmf = NodeManagerFactory.getInstance();
                nmf.getNodeManager(this.m_nodeList);
            }
            catch (NodeManagerFactoryException nmfEx) {
                Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
                throw new StageInitException(nmfEx.getMessage());
            }
        }
    }

    protected void setExcludeUserEquiv(boolean value) {
        this.m_excludeUserEquiv = value;
    }

    protected String[] getNodeList() {
        return this.m_nodeList;
    }

    protected String[] getValidNodeList() {
        return this.m_validNodeList;
    }

    protected void setValidNodeList(String[] validNodeList) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n Setting Valid Node list to: " + VerificationUtil.strArr2List(validNodeList)));
        }
        this.m_validNodeList = validNodeList;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    public abstract void generateReport();

    protected abstract void setTaskList() throws TaskFactoryException, PreReqNotSupportedException;

    protected boolean checkSetup() {
        return this.checkSetup(this.getNodeList());
    }

    protected boolean checkSetup(String[] nodeList) {
        String[] succNodeArr = nodeList;
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        Trace.out((String)" Performing checkSetup for stage...");
        if (this.m_excludeUserEquiv) {
            Trace.out((String)"Skipping the user equivalence check as it is not required in this context");
        }
        if (!this.m_excludeUserEquiv) {
            TaskNodeConnectivity taskNodeReach = new TaskNodeConnectivity(nodeList);
            taskNodeReach.setTaskType(1);
            boolean nodeReachSucc = taskNodeReach.perform();
            this.m_resultSet.uploadResultSet(taskNodeReach.getResultSet());
            if (!nodeReachSucc) {
                taskNodeReach.getResultSet().getSuccNodes(succNodes, failNodes);
                if (succNodes.size() == 0) {
                    ReportUtil.printError(s_msgBundle.getMessage("4095", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                ReportUtil.printWarning(s_msgBundle.getMessage("4096", false));
                ReportUtil.sureprintNodelist(failNodes);
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(succNodes);
                succNodeArr = succNodes.toArray(new String[succNodes.size()]);
            }
            TaskAdminPrivileges taskUserEquiv = new TaskAdminPrivileges(succNodeArr, "user_equiv");
            taskUserEquiv.setCheckNodeReach(false);
            boolean userEquivSucc = taskUserEquiv.perform();
            Trace.out((String)"Upload after performing User Equivalence check");
            this.m_resultSet.uploadResultSet(taskUserEquiv.getResultSet());
            if (!userEquivSucc) {
                succNodes.clear();
                failNodes.clear();
                taskUserEquiv.getResultSet().getSuccNodes(succNodes, failNodes);
                if (succNodes.size() == 0) {
                    ReportUtil.printError(s_msgBundle.getMessage("4008", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                ReportUtil.printWarning(s_msgBundle.getMessage("4009", false));
                ReportUtil.sureprintNodelist(failNodes);
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(succNodes);
                succNodeArr = succNodes.toArray(new String[succNodes.size()]);
            }
            succNodes.clear();
            failNodes.clear();
        }
        boolean destLocSucc = VerificationUtil.checkDestLoc(succNodeArr, this.m_resultSet, succNodes, failNodes, true);
        if (succNodes.size() > 0) {
            succNodeArr = succNodes.toArray(new String[succNodes.size()]);
            this.setValidNodeList(succNodeArr);
        }
        boolean succ = null == succNodeArr ? false : succNodeArr.length == nodeList.length;
        return succ;
    }

    protected boolean validateEnvironment() {
        VerificationUtil.setNoReportException(true);
        MessageBundle theMB = MessageBundle.getMessageBundle((MessageBundleList.FacilityList)MessageBundleList.FacilityList.Prvg);
        ErrorDescription errDesc = null;
        boolean check1 = false;
        boolean check2 = false;
        try {
            check1 = VerificationUtil.isHAConfigured() && !VerificationUtil.isCRSConfigured();
            check2 = VerificationUtil.isCRSConfigured();
        }
        catch (Exception e) {
            Trace.out((String)("Caught Exception" + e.getMessage()));
            return false;
        }
        if (check1) {
            String msg = theMB.getMessage("5740", true);
            Trace.out((String)msg);
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            Trace.out((String)msg);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        if (!check2) {
            String msg = theMB.getMessage("5745", true);
            Trace.out((String)msg);
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            Trace.out((String)msg);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        VerificationUtil.setNoReportException(false);
        return true;
    }

    public final boolean verify() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Inside Stage.verify()...");
        }
        this.checkSetup();
        this.m_resultSet.traceResultSet("After return from  checkSetup");
        if (null == this.getValidNodeList() || 0 == this.getValidNodeList().length) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"\n ==== NO VALID NODES ====");
            }
            return false;
        }
        try {
            this.setTaskList();
        }
        catch (TaskFactoryException e) {
            this.m_resultSet.addResult(this.getValidNodeList(), 2);
            this.m_resultSet.addErrorDescription(this.getValidNodeList(), new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (PreReqNotSupportedException e) {
            this.m_resultSet.addResult(this.getValidNodeList(), 2);
            this.m_resultSet.addErrorDescription(this.getValidNodeList(), new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"\n Tasks in Task Set List: ");
            for (int dbgi = 0; dbgi < this.m_currentTaskSet.size(); ++dbgi) {
                Task trcTask = (Task)this.m_currentTaskSet.get(dbgi);
                Trace.out((String)("TaskSet task: \n" + trcTask.getClass().getName()));
                if (!trcTask.hasSubtasks()) continue;
                try {
                    List<VerificationTask> subTaskList = trcTask.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        Trace.out((String)("         sub-task: \n" + subTask.getClass().getName()));
                    }
                    continue;
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.getValidNodeList(), 2);
                    this.m_resultSet.addErrorDescription(this.getValidNodeList(), new ErrorDescription(e.getMessage()));
                    ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
        }
        while (this.m_currentTaskSet.size() != 0) {
            boolean taskResult;
            Task task;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("m_currentTaskSet.size=" + this.m_currentTaskSet.size()));
            }
            if ((task = (Task)this.m_currentTaskSet.firstElement()).hasSubtasks()) {
                this.m_currentTaskSet.remove(0);
                try {
                    this.m_currentTaskSet.addAll(0, task.getSubtasks());
                    continue;
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.getValidNodeList(), 2);
                    this.m_resultSet.addErrorDescription(this.getValidNodeList(), new ErrorDescription(e.getMessage()));
                    ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            this.m_resultSet.traceResultSet("Before performing task:" + task.getClass().getName());
            try {
                taskResult = task.perform();
            }
            catch (Exception ex) {
                Trace.out((String)("Fatal error occured while executing the task " + task.getClass()));
                Trace.out((String)("Task Element" + task.getDefaultElementName()));
                Trace.out((String)("Exception :" + ex.getMessage()));
                Trace.out((Exception)ex);
                this.removeFromCurrentTaskSet(task);
                taskResult = false;
            }
            Trace.out((String)("Upload after performing task:" + task.getClass().getName()));
            this.m_resultSet.uploadResultSet(task.getResultSet());
            switch (task.getActionOnCompletion()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (taskResult) break;
                    return false;
                }
                case 3: {
                    if (taskResult || this.actionOnTaskError(task)) break;
                    return false;
                }
                case 4: {
                    if (this.actionOnTaskCompletion(task)) break;
                    return false;
                }
            }
        }
        this.generateReport();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Stage.verify(): setting status and exiting...");
        }
        return this.m_resultSet.getStatus() == 1 || this.m_resultSet.getStatus() == 4;
    }

    @Override
    public synchronized Vector getCurrentTaskSet() {
        return this.m_currentTaskSet;
    }

    @Override
    public synchronized void addToCurrentTaskSet(Task task) {
        this.m_currentTaskSet.addElement(task);
    }

    @Override
    public synchronized void addToCurrentTaskSet(Task[] taskArr) {
        for (int i = 0; i < taskArr.length; ++i) {
            this.m_currentTaskSet.addElement(taskArr[i]);
        }
    }

    @Override
    public synchronized void removeFromCurrentTaskSet(Task task) {
        this.m_currentTaskSet.removeElement(task);
    }

    @Override
    public boolean actionOnTaskError(Task task) {
        Trace.out((String)"Inside stage:actionOnTaskError()...");
        return true;
    }

    @Override
    public boolean actionOnTaskCompletion(Task task) {
        Trace.out((String)"Inside stage:actionOnTaskCompletion()...");
        return true;
    }
}

